<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id('idProd');
            $table->string('name');
            $table->string('description');
            $table->integer('stock');
            $table->integer('price');
            $table->bigInteger('category')->unsigned();
            $table->timestamps();

            $table->foreign('category')->references('idCat')->on('categories');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
