<?php
class Validator {
    private static function test_input($data){
        $data = trim($data);
        $data = stripslashes($data);
        return htmlspecialchars($data);
    }
    public static function dni($dni){
        if(empty($dni)){
            $dniError = "Este campo es requerido.";
        }elseif (!preg_match("/^[0-9]{8}[A-Z]$/", $dni)){
            $dniError = "El patrón introducido no coincide con el requerido.";
        }elseif (strlen($dni) !== 9){
            $dniError = "El DNI solo puede contener 9 caracteres.";
        }else{
            $dni = self::test_input($dni);
        }
        return $dniError ?? $dni;
    }

    public static function name($name){
        if(empty($name)){
            $nameError = "Este campo es requerido.";
        }elseif (!preg_match("/^[a-z áéíóúÁÉÍÓÚ]+$/i", $name)){
            $nameError = "El patrón introducido no coincide con el requerido.";
        }elseif (strlen($name) > 50){
            $nameError = "El nombre debe contener menos de 50 caracteres.";
        }else{
            $name = self::test_input($name);
        }
        return $nameError ?? $name;
    }

    public static function address($address){
        if(empty($address)){
            $addressError = "Este campo es requerido.";
        }elseif (!preg_match("/^C\/[a-z áéíóúÁÉÍÓÚ]+(, [0-9]*)?$/i", $address)){
            $addressError = "El patrón introducido no coincide con el requerido.";
        }elseif (strlen($address) > 50){
            $addressError = "El nombre debe contener menos de 50 caracteres.";
        }else{
            $address = self::test_input($address);
        }
        return $addressError ?? $address;
    }

    public static function telephone($telephone){
        if(empty($telephone)){
            $telephoneError = "Este campo es requerido.";
        }elseif (!preg_match("/^[0-9]{9}?$/", $telephone)){
            $telephoneError = "El patrón introducido no coincide con el requerido.";
        }elseif (strlen($telephone) !== 9){
            $telephoneError = "El teléfono solo puede contener 9 caracteres.";
        }else{
            $telephone = self::test_input($telephone);
        }
        return $telephoneError ?? $telephone;
    }
}