<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--<link rel="stylesheet" href="../assets/index.css">-->
    <title>Eliminar Ciente</title>
    <style>
        body {
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-items: center;
            align-items: center;
            font-family: sans-serif;
        }

        table {
            border-collapse: collapse;
            border-top: 0.2rem solid #505050;
            border-bottom: 0.2rem solid #505050;
            width: 50vw;

        }

        th, td {
            padding: 1rem 1rem;
        }

        th{
            color: #355db5;
            background-color: #e8edff;
        }

        td {
            color: #000000;
            background-color: white;
            border-top: 0.1rem solid rgba(0, 0, 0, 0.32);
        }

        tr td {
            background-color: rgba(243, 243, 243, 0.69);
        }

        input::placeholder, input:defined, input:focus {
            text-align: center;
        }

        input:focus {
            outline-color: #355db5;
        }

        section {
            width: 15vw;
            height: 5vh;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: bold;
            margin-top: 1.5rem;
            & input {
                all: unset;
                cursor: pointer;
                padding: 0.5rem 0.7rem;
                border-radius: 0.3rem;
                color: white;
                text-decoration: none;
                font-weight: bold;
                &.update {
                    width: 5rem;
                    background-color: rgba(218, 159, 10, 0.8);
                    &:hover {
                        box-shadow: 0.1rem 0.1rem 0.5rem #E7AF33FF;
                    }
                }
            }
            & a {
                all: unset;
                cursor: pointer;
                padding: 0.5rem 0.7rem;
                border-radius: 0.3rem;
                color: white;
                text-decoration: none;
                font-weight: bold;
                &.comeback {
                    width: 5rem;
                    background-color: rgba(2, 148, 13, 0.8);
                    &:hover {
                        box-shadow: 0.1rem 0.1rem 0.5rem #1dad24;
                    }
                }
            }
        }

        .important {
            font-weight: bold;
            color: #E7AF33FF;
            text-shadow: 0 0 0.1rem rgba(218, 159, 10, 0.8);
        }

        p.important {
            font-size: large;
        }

        .error{
            color: #c90000;
            font-size: smaller;
        }

    </style>

</head>
<body>
    <h1>Modificar Cliente</h1>
    <p>Está usted a punto de <span class="important">modificar</span> el siguiente cliente de la Base de Datos:</p>
    <table>
        <thead>
        <tr>
            <th>DNI</th>
            <th>Nombre</th>
            <th>Dirección</th>
            <th>Teléfono</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?= $client[0]->dni ?></td>
            <td><?= $client[0]->name ?></td>
            <td><?= $client[0]->address ?></td>
            <td><?= $client[0]->telephone ?></td>
        </tr>
        <tr>
            <form action="index.php?method=update&dni=<?= $client[0]->dni ?>" method="POST">
                <td>
                    <input type="text" id="dni" name="dni" placeholder="00000000A" value="<?= $client[0]->dni ?? '' ?>" readonly>
                </td>
                <td>
                    <input type="text" id="name" name="name" value="<?= $client[0]->name ?? '' ?>">
                </td>
                <td>
                    <input type="text" id="address" name="address" placeholder="C/Estrella, 3" value="<?= $client[0]->address ?? '' ?>">
                </td>
                <td>
                    <input type="text" id="telephone" name="telephone" placeholder="000000000" value="<?= $client[0]->telephone ?? '' ?>">
                </td>
        </tr>
        </tbody>
        <?php
        if(isset($nameError) || isset($addressError) || isset($telephoneError)){
            ?>
            <tfoot>
            <tr>
                <td><span class="error"><?= $dniError ?? "" ?></span></td>
                <td><span class="error"><?= $nameError ?? "" ?></span></td>
                <td><span class="error"><?= $addressError ?? "" ?></span></td>
                <td><span class="error"><?= $telephoneError ?? "" ?></span></td>
            </tr>
            </tfoot>
            <?php
        }
        ?>
    </table>
    <p class="important">¿Está seguro de que quiere modificarlo?</p>
    <section>
        <input type="submit" name="update" value="Modificar" class="update">
        <a href="?method=index" class="comeback">Volver</a>
    </section>
    </form>
</body>
</html>