<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--<link rel="stylesheet" href="../assets/index.css">-->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <title>Listar</title>
    <style>
        body {
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-items: center;
            align-items: center;
            font-family: sans-serif;
        }

        table {
            border-collapse: collapse;
            border-top: 0.2rem solid #505050;
            border-bottom: 0.2rem solid #505050;
            width: 50vw;

        }

        th, td {
            padding: 1rem 1rem;
        }

        th{
            color: #355db5;
            background-color: #e8edff;
        }

        td {
            color: #000000;
            background-color: white;
            border-top: 0.1rem solid rgba(0, 0, 0, 0.32);
        }

        tr:nth-child(even) td{
            background-color: #eaeaea;
        }

        tr td {
            background-color: rgba(243, 243, 243, 0.69);
        }

        a, input.create {
            all: unset;
            cursor: pointer;
            padding: 0.5rem 0.7rem;
            border-radius: 0.3rem;
            color: white;
            text-decoration: none;
            font-weight: bold;
        }

        input::placeholder, input:defined, input:focus {
            text-align: center;
        }

        input:focus {
            outline-color: #355db5;
        }

        a.delete {
            display: inline-flex;
            background-color: rgba(236, 38, 38, 0.75);
            &:hover {
                box-shadow: 0.1rem 0.1rem 0.5rem #ea3131;
            }
        }

        a.update {
            display: inline-flex;
            background-color: rgba(218, 159, 10, 0.8);
            &:hover {
                box-shadow: 0.1rem 0.1rem 0.5rem #E7AF33FF;
            }
        }

        i {
            margin-right: 0.5rem;
        }

        input.create {
            background-color: rgba(2, 148, 13, 0.8);
            padding-left: 2.5rem;
            &:hover {
                box-shadow: 0.1rem 0.1rem 0.5rem #1dad24;
            }
        }

        i.position {
            position: relative;
            left: 2.5rem;
            color: white;
        }

        footer {
            width: 15vw;
            height: 5vh;
            display: flex;
            justify-content: space-evenly;
            align-items: center;
            font-weight: bold;
        }

        a.pagination-enabled {
            color: #355db5;
        }

        a.pagination-disabled {
            color: #b7c6e3;
            cursor: default;
        }

        .error{
            color: #c90000;
            font-size: smaller;
        }

        .feedback {
            margin-top: 2rem;
            padding: 2rem;
        }

        .good {
            border: 0.15rem solid rgba(2, 148, 13, 0.8);
            background-color: rgba(77, 215, 86, 0.8);
        }

        .bad {
            border: 0.15rem solid rgb(183 8 8);
            background-color: rgb(255 130 130 / 64%);
        }
    </style>

</head>
<body>
<h1>Lista de clientes</h1>
    <table>
        <thead>
            <tr>
                <th>DNI</th>
                <th>Nombre</th>
                <th>Dirección</th>
                <th>Teléfono</th>
                <th></th>
                <th></th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($clients as $client) {?>
            <tr>
                <td><?= $client->dni ?></td>
                <td><?= $client->name ?></td>
                <td><?= $client->address ?></td>
                <td><?= $client->telephone ?></td>
                <td><a href="?method=delete&dni=<?= $client->dni ?>" class="delete"><i class="fa-solid fa-trash-can"></i>Eliminar</a></td>
                <td><a href="?method=update&dni=<?= $client->dni ?>" class="update"><i class="fa-solid fa-pen-to-square"></i>Modificar</a></td>
            </tr>
        <?php } ?>
            <tr>

                <form action="index.php?method=create" method="POST">
                    <td>
                        <input type="text" id="dni" name="dni" placeholder="00000000A" value="<?= $dni ?? '' ?>">
                    </td>
                    <td>
                        <input type="text" id="name" name="name" value="<?= $name ?? '' ?>">
                    </td>
                    <td>
                        <input type="text" id="address" name="address" placeholder="C/Estrella, 3" value="<?= $address ?? '' ?>">
                    </td>
                    <td>
                        <input type="text" id="telephone" name="telephone" placeholder="000000000" value="<?= $telephone ?? '' ?>">
                    </td>
                    <td colspan="2">
                        <i class="fa-solid fa-user-check position"></i><input type="submit" name="create" value="Nuevo Cliente" class="create">
                    </td>
                </form>

                <!--
                <td colspan="2">
                    <a href="?method=create" class="create">Nuevo Cliente</a>
                </td>
                -->
            </tr>
        </tbody>
        <?php
        if(isset($dniError) || isset($nameError) || isset($addressError) || isset($telephoneError)){
        ?>
        <tfoot>
            <tr>
                <td><span class="error"><?= $dniError ?? "" ?></span></td>
                <td><span class="error"><?= $nameError ?? "" ?></span></td>
                <td><span class="error"><?= $addressError ?? "" ?></span></td>
                <td><span class="error"><?= $telephoneError ?? "" ?></span></td>
                <td colspan="2"></td>
            </tr>
        </tfoot>
        <?php
        }
        ?>
    </table>
    <footer>
    <?php
    //Si no estoy en la página 2 o superior, el botón anterior estará desactivado.
    if($page < 2){
        ?>
        <a class="pagination-disabled">Anterior</a>
        <?php
    }else{
        ?>
        <a href="?method=index&page=<?= $page - 1 ?>" class="pagination-enabled">Anterior</a>
        <?php
    }

    //Si el número de filas de la tabla de la base de datos es menor o igual que el número de páginas por el número de filas que se muestran, el botón anterior estará desactivado.
    if($totalPages <= ($page * 5)){
        ?>
        <a class="pagination-disabled">Siguiente</a>
        <?php
    }else{
        ?>
        <a href="?method=index&page=<?= $page + 1 ?>" class="pagination-enabled">Siguiente</a>
        <?php
    }
    ?>
    </footer>
    <?php
    echo $_GET["feedback"] ?? "";
    ?>
</body>
</html>