<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <!--<link rel="stylesheet" href="../assets/index.css">-->
    <title>Eliminar Ciente</title>
    <style>
        body {
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-items: center;
            align-items: center;
            font-family: sans-serif;
        }

        table {
            border-collapse: collapse;
            border-top: 0.2rem solid #505050;
            border-bottom: 0.2rem solid #505050;
            width: 50vw;

        }

        th, td {
            padding: 1rem 1rem;
        }

        th{
            color: #355db5;
            background-color: #e8edff;
        }

        td {
            color: #000000;
            background-color: white;
            border-top: 0.1rem solid rgba(0, 0, 0, 0.32);
        }

        tr td {
            background-color: rgba(243, 243, 243, 0.69);
        }

        section {
            width: 15vw;
            height: 5vh;
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-weight: bold;
            margin-top: 1.5rem;
            & input {
                all: unset;
                cursor: pointer;
                padding: 0.5rem 0.7rem;
                border-radius: 0.3rem;
                color: white;
                text-decoration: none;
                font-weight: bold;
                &.delete {
                    width: 5rem;
                    background-color: rgba(236, 38, 38, 0.75);
                    &:hover {
                        box-shadow: 0.1rem 0.1rem 0.5rem #ea3131;
                    }
                }
            }
            & a {
                all: unset;
                cursor: pointer;
                padding: 0.5rem 0.7rem;
                border-radius: 0.3rem;
                color: white;
                text-decoration: none;
                font-weight: bold;
                &.comeback {
                    width: 5rem;
                    background-color: rgba(2, 148, 13, 0.8);
                    &:hover {
                        box-shadow: 0.1rem 0.1rem 0.5rem #1dad24;
                    }
                }
            }
        }

        .important {
            font-weight: bold;
            color: #ea3131;
            text-shadow: 0 0 0.1rem rgba(236, 38, 38, 0.75);
        }

        p.important {
            font-size: large;
        }
    </style>

</head>
<body>
    <h1>Eliminar Cliente</h1>
    <p>Está usted a punto de <span class="important">eliminar</span> el siguiente cliente de la Base de Datos:</p>
    <table>
        <thead>
        <tr>
            <th>DNI</th>
            <th>Nombre</th>
            <th>Dirección</th>
            <th>Teléfono</th>
        </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= $client[0]->dni ?></td>
                <td><?= $client[0]->name ?></td>
                <td><?= $client[0]->address ?></td>
                <td><?= $client[0]->telephone ?></td>
            </tr>
        </tbody>
    </table>
    <p class="important">¿Está seguro de que quiere eliminarlo? Esta acción será permanente y no se podrá deshacer.</p>
    <form action="index.php?method=delete&dni=<?= $client[0]->dni ?>" method="POST">
        <section>

            <input type="submit" name="delete" value="Eliminar" class="delete">
            <!--<a href="?method=delete&dni=" class="delete">Eliminar</a>-->
            <a href="?method=index" class="comeback">Volver</a>
            <!--
            <input type="submit" name="comeback" value="Volver" class="comeback">-->

        </section>
    </form>
</body>
</html>