<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Nuevo Usuario</title>
    <style>
        body {
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-items: center;
            align-items: center;
            font-family: sans-serif;
        }

        form {
            border-top: 0.2rem solid #505050;
            border-bottom: 0.2rem solid #505050;
            width: 25vw;
            background-color: #e8edff;
            padding: 1rem 0;
        }

        form > section {
            margin: 1em 0;
        }

        .required{
            color: #c90000;
        }

        input{
            all: unset;
            text-align: center;
            border: 0.1rem solid black;
            border-radius: 0.2rem;
            background-color: white;
            padding: 0.1rem 0;
            margin-top: 0.5rem;
        }

        input:focus{
            background-color: #eeeeee;
        }

        input::selection{
            background-color: #eeeeee;
        }

        input.btn {
            padding: 0.5rem 1rem;
            color: #355db5;
        }

        input.btn:hover {
            padding: 0.5rem 1rem;
            border: 0.1rem solid white;
            background-color: #355db5;
            color: white;
            cursor: pointer;
            box-shadow: 0.1rem 0.1rem 0.5rem #858585;
        }
    </style>
</head>
<body>
<header>
    <h1>Nuevo Cliente</h1>
</header>
<main>
    <form action="" method="post">
        <section>
            <article>
                <label for="dni">DNI</label><span class="required"> *</span>
            </article>
            <article>
                <input type="text" id="dni" name="dni" required>
            </article>
        </section>
        <section>
            <article>
                <label for="name">Nombre</label><span class="required"> *</span>
            </article>
            <article>
                <input type="text" id="name" name="name" required>
            </article>
        </section>
        <section>
            <article>
                <label for="address">Dirección</label><span class="required"> *</span>
            </article>
            <article>
                <input type="text" id="address" name="address" required>
            </article>
        </section>
        <section>
            <article>
                <label for="telephone">Teléfono</label><span class="required"> *</span>
            </article>
            <article>
                <input type="text" id="telephone" name="telephone" required>
            </article>
        </section>
        <section>
            <input class="btn" type="submit" name="save" value="Guardar">
        </section>
    </form>
</main>
</body>
</html>