<?php
require_once __DIR__ . "/../../core/Model.php";
class Client extends Model {
    public static function all(): array {
        $pdo = Client::db();
        try{
            $sql = "SELECT * FROM clients ORDER BY 2";
            $statement = $pdo->prepare($sql);
            $statement->execute();
            $clients = $statement->fetchAll(PDO::FETCH_CLASS, Client::class);
        }catch (PDOException $e){
            die("<p>ERROR: Could not able to execute $sql. ".$e->getMessage()."</p>");
        }
        return $clients;
    }

    public static function create($dni, $name, $address, $telephone): string {
        $pdo = Client::db();
        try{
            $sql = "INSERT INTO clients (dni, name, address, telephone) VALUES (:dni, :name, :address, :telephone);";

            $stmt = $pdo->prepare($sql);

            $stmt->bindParam(':dni', $dni);
            $stmt->bindParam(':name', $name);
            $stmt->bindParam(':address', $address);
            $stmt->bindParam(':telephone', $telephone);

            $stmt->execute();
            return "<span class='feedback good'>Cliente añadido correctamente.</span>";

        } catch(PDOException $e){
            return "<span class='feedback bad'>Error al crear el cliente.</span><span class='feedback error'>".$e->getMessage()."</span>";
        }
    }

    public static function find($dni): array {
        $pdo = Client::db();
        try{
            $sql = "SELECT * FROM clients WHERE dni='$dni'";
            $statement = $pdo->prepare($sql);
            $statement->execute();
            return $statement->fetchAll(PDO::FETCH_CLASS, Client::class);
        }catch (PDOException $e){
            die("<p>ERROR: Could not able to execute $sql. ".$e->getMessage()."</p>");
        }
    }
    public static function delete($dni): void {
        $pdo = Client::db();
        try {
            $sql = "DELETE FROM clients WHERE dni='$dni'";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            //Quitar html
        } catch(PDOException $e){
            die("<p>ERROR: Could not able to execute $sql. ".$e->getMessage()."</p>");
        }
    }

    public static function update($dni, $name, $address, $telephone): string {
        $pdo = Client::db();
        try {
            $sql = "UPDATE clients SET name='$name', address='$address', telephone='$telephone' WHERE dni='$dni'";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            return "<span class='feedback good'>Cliente con DNI: $dni modificado correctamente.</span>";

        } catch(PDOException $e){
            return "<span class='feedback bad'>Error al modificar el cliente con DNI: $dni.</span><span class='feedback error'>".$e->getMessage()."</span>";
        }
    }

    public static function allPaginated($offset, $limit): array{
        $pdo = Client::db();
        try{
            $sql = "SELECT * FROM clients  ORDER BY 2 LIMIT $offset, $limit";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $clients = $stmt->fetchAll(PDO::FETCH_CLASS, Client::class);

        } catch(PDOException $e){
            die("<p>ERROR: Could not able to execute $sql. ".$e->getMessage()."</p>");
        }
        return $clients;
    }

    public static function count(): int {
        $pdo = Client::db();
        try{
            $sql = "SELECT COUNT(*) AS clientsCount FROM clients";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $count = $stmt->fetch();

        } catch(PDOException $e){
            die("<p>ERROR: Could not able to execute $sql. ".$e->getMessage()."</p>");
        }
        return $count["clientsCount"];
    }
}