<?php
require_once __DIR__ . "/../models/Client.php";
require_once __DIR__ . "/../../core/Validator.php";
class ClientController {
    public function index(): void {
        //$clients = Client::all();
        $page = $_GET["page"] ?? 1;
        $totalPages = Client::count();
        $clients = Client::allPaginated(($page - 1) * 5, 5);
        require __DIR__ . "/../views/index.php";
    }

    public function create(): void {
        //AQUÍ IRÁ LA VALIDACIÓN
        if(isset($_POST['dni'])){
            if(!empty(Client::find($_POST['dni']))){
                $feedback = "<span class='feedback bad'>El DNI: ".$_POST['dni']." ya está almacenado.</span>";
            }else {

                $_POST["dni"] === Validator::dni($_POST["dni"]) ? $dni = Validator::dni($_POST["dni"]) : $dniError = Validator::dni($_POST["dni"]);

                $_POST["name"] === Validator::name($_POST["name"]) ? $name = Validator::name($_POST["name"]) : $nameError = Validator::name($_POST["name"]);

                $_POST["address"] === Validator::address($_POST["address"]) ? $address = Validator::address($_POST["address"]) : $addressError = Validator::address($_POST["address"]);

                $_POST["telephone"] === Validator::telephone($_POST["telephone"]) ? $telephone = Validator::telephone($_POST["telephone"]) : $telephoneError = Validator::telephone($_POST["telephone"]);

                if(!isset($dniError) && !isset($nameError) && !isset($addressError) && !isset($telephoneError)){
                    $feedback = Client::create($dni, $name, $address, $telephone);}
            }
            /*$this->index();
        }else{
            //PREGUNTAR A EDU:
            //Tengo que copiar el código, porque si llamo a la función se me pierden las variables.
            $page = $_GET["page"] ?? 1;
            $totalPages = Client::count();
            $clients = Client::allPaginated(($page - 1) * 5, 5);
            require __DIR__ . "/../views/index.php";
        }*/
            $page = $_GET["page"] ?? 1;
            $totalPages = Client::count();
            $clients = Client::allPaginated(($page - 1) * 5, 5);
            require __DIR__ . "/../views/index.php";

            //header("Location: ./index.php"); Con el header puedo pasarle un parámetro para mostrar el feedback
        }
    }

    public function delete(): void {
        $dni = $_GET["dni"];

        if(!isset($_POST["delete"])){
            $client = Client::find($dni);
            if(empty($client)){
                $feedback = "<span class='feedback bad'>No se ha encontrado ningún cliente con DNI: $dni.</span>";
                header("Location: ./index.php?feedback=$feedback");
            }else{
                require __DIR__ . "/../views/delete.php";
            }
        } else {
            Client::delete($dni);
            $feedback = "<span class='feedback good'>Cliente con DNI: $dni eliminado correctamente.</span>";
            /*$page = $_GET["page"] ?? 1;
            $totalPages = Client::count();
            $clients = Client::allPaginated(($page - 1) * 5, 5);
            require __DIR__ . "/../views/index.php";*/
            header("Location: ./index.php?feedback=$feedback");
        }
    }

    public function update(): void {
        $dni = $_GET["dni"] ?? "";
        $name = $_POST["name"] ?? "";
        $address = $_POST["address"] ?? "";
        $telephone = $_POST["telephone"] ?? "";

        if(!isset($_POST["update"])){
            $client = Client::find($dni);
            require __DIR__ . "/../views/update.php";
        } else {
            $name === Validator::name($name) ? $name = Validator::name($name) : $nameError = Validator::name($name);

            $address === Validator::address($address) ? $address = Validator::address($address) : $addressError = Validator::address($address);

            $telephone === Validator::telephone($telephone) ? $telephone = Validator::telephone($telephone) : $telephoneError = Validator::telephone($telephone);

            if(!isset($nameError) && !isset($addressError) && !isset($telephoneError)){
                $feedback = Client::update($dni, $name, $address, $telephone);

                $page = $_GET["page"] ?? 1;
                $totalPages = Client::count();
                $clients = Client::allPaginated(($page - 1) * 5, 5);
                require __DIR__ . "/../views/index.php";
            } else {
                $client = Client::find($dni);
                require __DIR__ . "/../views/update.php";
            }
        }
    }
}